from lib.utils.localization.countries import find_language_by_unicode
import re

langsSet = {
    "bosnian",
    "ro",
    "swedish",
    "mac",
    "tr",
    "rw",
    "ind",
    "czech",
    "nl",
    "he",
    "lithuanian",
    "sāmo",
    "nor",
    "རྫོང",
    "ger",
    "azə",
    "shq",
    "cze",
    "hu",
    "danish",
    "hy",
    "mag",
    "ms",
    "tajik",
    "پښت",
    "kaz",
    "mk",
    "vietnamese",
    "sk",
    "бъл",
    "ps",
    "lt",
    "cs",
    "mongolian",
    "jap",
    "geo",
    "ko",
    "dan",
    "dzongkha",
    "th",
    "norwegian",
    "az",
    "mt",
    "por",
    "kala",
    "sin",
    "ja",
    "pol",
    "is",
    "nepali",
    "việt",
    "тоҷ",
    "amh",
    "irish",
    "chinese",
    "pl",
    "қаз",
    "maltese",
    "tg",
    "arabic",
    "ລາວ",
    "khm",
    "ukr",
    "hin",
    "am",
    "ne",
    "føroy",
    "et",
    "macedonian",
    "polish",
    "ita",
    "tur",
    "ქართული",
    "gre",
    "spa",
    "বেঙ্গ",
    "عرب",
    "kyr",
    "rus",
    "bs",
    "si",
    "sr",
    "belarusian",
    "kl",
    "my",
    "bel",
    "o'zb",
    "бел",
    "नेप",
    "sam",
    "albanian",
    "faroese",
    "turkish",
    "spanish",
    "da",
    "georgian",
    "malay",
    "km",
    "divehi",
    "greek",
    "فارسی",
    "iri",
    "bengali",
    "melay",
    "ben",
    "mn",
    "id",
    "монгол",
    "kin",
    "portuguese",
    "dutch",
    "ar",
    "de",
    "icelandic",
    "bg",
    "slov",
    "hi",
    "norsk",
    "est",
    "viet",
    "dz",
    "rom",
    "kyrgyz",
    "fran",
    "chi",
    "ka",
    "malaysian",
    "fa",
    "vi",
    "catalan",
    "ser",
    "ru",
    "indo",
    "fo",
    "pt",
    "mal",
    "burmese",
    "kor",
    "ga",
    "korean",
    "fin",
    "lit",
    "amharic",
    "nep",
    "dzo",
    "italian",
    "heb",
    "be",
    "bulgarian",
    "eest",
    "укр",
    "አማ",
    "ísl",
    "el",
    "lv",
    "turkmen",
    "日",
    "bur",
    "हिं",
    "עבר",
    "tha",
    "taj",
    "мак",
    "sq",
    "uk",
    "bos",
    "sven",
    "slo",
    "japanese",
    "hun",
    "french",
    "esp",
    "serbian",
    "croatian",
    "türkmen",
    "alb",
    "kal",
    "uz",
    "mla",
    "eng",
    "german",
    "ខ្មែរ",
    "hebrew",
    "ice",
    "cro",
    "mon",
    "ελλ",
    "sinhalese",
    "рус",
    "lo",
    "fr",
    "ca",
    "sv",
    "uzbek",
    "aze",
    "հայ",
    "ara",
    "hindi",
    "မြန်",
    "kalaallisut",
    "es",
    "it",
    "kazakh",
    "kk",
    "slovak",
    "per",
    "sl",
    "suom",
    "češ",
    "hungarian",
    "finnish",
    "thai",
    "zh",
    "hr",
    "ky",
    "arm",
    "slovene",
    "persian",
    "cat",
    "bn",
    "ukrainian",
    "ދިވެ",
    "sve",
    "div",
    "fre",
    "кыргыз",
    "uzb",
    "estonian",
    "kinyarwanda",
    "hrv",
    "no",
    "pashto",
    "azerbaijani",
    "gae",
    "latvian",
    "du",
    "en",
    "ned",
    "срп",
    "samoan",
    "中",
    "tk",
    "lao",
    "indonesian",
    "sm",
    "한",
    "khmer",
    "bul",
    "pas",
    "far",
    "armenian",
    "ไทย",
    "fi",
    "english",
    "liet",
    "romanian",
    "russian",
    "tür",
    "සිං",
    "cas",
    "castellano",
    "castilian",
}
language_codes = {
    "bosnian": "bs",
    "ro": "ro",
    "swedish": "sv",
    "mac": "mk",
    "tr": "tr",
    "rw": "rw",
    "ind": "id",
    "czech": "cs",
    "nl": "nl",
    "he": "he",
    "lithuanian": "lt",
    "sāmo": "sm",
    "nor": "no",
    "རྫོང": "dz",
    "ger": "de",
    "azə": "az",
    "shq": "sq",
    "lat": "lv",
    "cze": "cs",
    "hu": "hu",
    "danish": "da",
    "hy": "hy",
    "mag": "mk",
    "ms": "ms",
    "tajik": "tg",
    "پښت": "ps",
    "kaz": "kk",
    "mk": "mk",
    "vietnamese": "vi",
    "sk": "sk",
    "бъл": "bg",
    "ps": "ps",
    "lt": "lt",
    "cs": "cs",
    "mongolian": "mn",
    "jap": "ja",
    "geo": "ka",
    "ko": "ko",
    "dan": "da",
    "dzongkha": "dz",
    "th": "th",
    "norwegian": "no",
    "az": "az",
    "mt": "mt",
    "por": "pt",
    "kala": "kl",
    "sin": "si",
    "ja": "ja",
    "pol": "pl",
    "is": "is",
    "nepali": "ne",
    "việt": "vi",
    "тоҷ": "tj",
    "amh": "am",
    "irish": "ga",
    "chinese": "zh",
    "pl": "pl",
    "қаз": "kk",
    "maltese": "mt",
    "tg": "tg",
    "arabic": "ar",
    "ລາວ": "lo",
    "khm": "km",
    "ukr": "uk",
    "hin": "hi",
    "am": "am",
    "ne": "ne",
    "føroy": "fo",
    "et": "et",
    "macedonian": "mk",
    "polish": "pl",
    "ita": "it",
    "tur": "tr",
    "ქართული": "ka",
    "gre": "el",
    "spa": "es",
    "বেঙ্গ": "bn",
    "عرب": "ar",
    "kyr": "ky",
    "rus": "ru",
    "bs": "bs",
    "si": "si",
    "sr": "sr",
    "belarusian": "be",
    "kl": "kl",
    "my": "my",
    "bel": "be",
    "o'zb": "uz",
    "бел": "be",
    "नेप": "ne",
    "sam": "sm",
    "albanian": "sq",
    "faroese": "fo",
    "turkish": "tr",
    "spanish": "es",
    "da": "da",
    "georgian": "ka",
    "malay": "ms",
    "km": "km",
    "divehi": "dv",
    "greek": "el",
    "فارسی": "fa",
    "iri": "fa",
    "bengali": "bn",
    "melay": "ms",
    "ben": "bn",
    "mn": "mn",
    "id": "id",
    "монгол": "mn",
    "kin": "rw",
    "portuguese": "pt",
    "dutch": "nl",
    "ar": "ar",
    "de": "de",
    "icelandic": "is",
    "bg": "bg",
    "slov": "sk",
    "hi": "hi",
    "norsk": "no",
    "est": "et",
    "viet": "vi",
    "dz": "dz",
    "rom": "ro",
    "kyrgyz": "ky",
    "fran": "fr",
    "chi": "zh",
    "ka": "ka",
    "malaysian": "ms",
    "fa": "fa",
    "vi": "vi",
    "catalan": "ca",
    "ser": "sr",
    "ru": "ru",
    "indo": "id",
    "fo": "fo",
    "pt": "pt",
    "mal": "ms",
    "burmese": "my",
    "kor": "ko",
    "ga": "ga",
    "korean": "ko",
    "fin": "fi",
    "lit": "lt",
    "amharic": "am",
    "nep": "ne",
    "dzo": "dz",
    "italian": "it",
    "heb": "he",
    "be": "be",
    "bulgarian": "bg",
    "eest": "et",
    "укр": "uk",
    "አማ": "am",
    "ísl": "is",
    "el": "el",
    "lv": "lv",
    "turkmen": "tk",
    "日": "ja",
    "bur": "my",
    "हिं": "hi",
    "עבר": "he",
    "tha": "th",
    "taj": "tg",
    "мак": "mk",
    "sq": "sq",
    "uk": "uk",
    "bos": "bs",
    "sven": "sv",
    "slo": "sk",
    "japanese": "ja",
    "hun": "hu",
    "french": "fr",
    "esp": "es",
    "serbian": "sr",
    "croatian": "hr",
    "türkmen": "tk",
    "alb": "sq",
    "kal": "kl",
    "uz": "uz",
    "mla": "ms",
    "eng": "en",
    "german": "de",
    "ខ្មែរ": "km",
    "hebrew": "he",
    "ice": "is",
    "cro": "hr",
    "mon": "mn",
    "ελλ": "el",
    "sinhalese": "si",
    "рус": "ru",
    "lo": "lo",
    "fr": "fr",
    "ca": "ca",
    "sv": "sv",
    "uzbek": "uz",
    "aze": "az",
    "հայ": "hy",
    "ara": "ar",
    "hindi": "hi",
    "မြန်": "my",
    "kalaallisut": "kl",
    "es": "es",
    "it": "it",
    "kazakh": "kk",
    "kk": "kk",
    "slovak": "sk",
    "per": "fa",
    "sl": "sl",
    "suom": "fi",
    "češ": "cs",
    "hungarian": "hu",
    "finnish": "fi",
    "thai": "th",
    "zh": "zh",
    "hr": "hr",
    "ky": "ky",
    "arm": "hy",
    "slovene": "sl",
    "persian": "fa",
    "cat": "ca",
    "bn": "bn",
    "ukrainian": "uk",
    "ދިވެ": "dv",
    "sve": "sv",
    "div": "dv",
    "fre": "fr",
    "кыргыз": "ky",
    "uzb": "uz",
    "estonian": "et",
    "kinyarwanda": "rw",
    "hrv": "hr",
    "no": "no",
    "pashto": "ps",
    "azerbaijani": "az",
    "gae": "ga",
    "latvian": "lv",
    "du": "nl",
    "en": "en",
    "ned": "nl",
    "срп": "sr",
    "samoan": "sm",
    "中": "zh",
    "tk": "tk",
    "dv": "dv",
    "lao": "lo",
    "indonesian": "id",
    "sm": "sm",
    "한": "ko",
    "khmer": "km",
    "bul": "bg",
    "pas": "ps",
    "far": "fa",
    "armenian": "hy",
    "ไทย": "th",
    "fi": "fi",
    "english": "en",
    "liet": "lt",
    "romanian": "ro",
    "russian": "ru",
    "tür": "tr",
    "සිං": "si",
    "cas": "es",
    "castellano": "es",
    "castilian": "es",
}


def extract_unicode_flags(text):
    flag_pattern = re.compile(r"[\U0001F1E6-\U0001F1FF]{2}")
    flags = flag_pattern.findall(text)
    return flags


def find_languages_in_string(s: str) -> set:
    pattern = r"\b(?:" + "|".join(re.escape(word) for word in langsSet) + r")\b"
    flags = " ".join(
        [find_language_by_unicode(flag) for flag in extract_unicode_flags(s)]
    )
    swf = f"{s} {flags}"
    matches = re.findall(pattern, swf.lower())
    matches = [language_codes.get(match) for match in matches]
    return set(matches)
