#cache for vietmediaf
import os
import time
import json
import xbmcvfs

CACHE_TIMEOUT = 600  
CACHE_PATH = xbmcvfs.translatePath("special://temp")

def check_cache(cache_path):
    if xbmcvfs.exists(cache_path):
        file_modification_time = os.path.getmtime(cache_path)
        current_time = time.time()
        elapsed_time = current_time - file_modification_time
        
        if elapsed_time > CACHE_TIMEOUT:
            return False
        else:
            return True
    else:
        return False

def get_cache(cache_path):
    with open(cache_path, 'r') as cache_file:
        cache_content = json.load(cache_file)
    return cache_content

def set_cache(cache_path, data):
    with open(cache_path, 'w') as cache_file:
        json.dump(data, cache_file)