import requests
import xbmcgui, xbmc, xbmcvfs
import time
import os, sys
import threading

from addon import alert, notify, TextBoxes, ADDON, ADDON_ID, ADDON_PROFILE, LOG, PROFILE

def download_file(url, path):
    response = requests.head(url)
    size = int(response.headers.get("Content-Length", 0))
    file_name = url.split('/')[-1]
    path = os.path.join(path, file_name)
    
    if xbmcvfs.exists(path):
        dialog = xbmcgui.Dialog()
        overwrite = dialog.yesno("File Exists", "Bạn có muốn xoá đè file cũ không?")
        if not overwrite:
            return False
    
    def download_thread():
        start_time = time.time()
        downloaded = 0
        with requests.get(url, stream=True) as r:
            r.raise_for_status()
            with open(path, "wb") as f:
                for chunk in r.iter_content(chunk_size=8192):
                    if chunk:
                        f.write(chunk)
                        downloaded += len(chunk)
                        progress = int(downloaded / size * 100)
                        speed = downloaded / (time.time() - start_time)
                        time_left = (size - downloaded) / speed if speed > 0 else 0
                        notify("Downloading: {}%".format(progress))
                        if xbmc.Monitor().abortRequested():
                            notify("Download cancelled")
                            os.remove(path)
                            return

        notify('Download Completed', 'File download completed.')
        if xbmcgui.Dialog().yesno("Play file?", "Bạn có muốn play luôn video này không?"):
            xbmc.Player().play(path)
    
    # Bắt đầu tải xuống trong một thread riêng biệt
    download_thread = threading.Thread(target=download_thread)
    download_thread.start()

    return True

# Sử dụng hàm
# download_file(url, path)