import re, json, os, io
import requests,xbmcvfs
import urlquick, htmlement
import hashlib
from resources import fshare, cache_utils
import datetime as dt
import time
import xbmcplugin, xbmcaddon, xbmcgui, xbmc, xbmcvfs
from addon import alert, notify, TextBoxes, ADDON, ADDON_ID, ADDON_PROFILE, LOG, PROFILE
from resources import resetfs
CACHE_PATH = xbmcvfs.translatePath("special://temp")
PROFILE_PATH = xbmcvfs.translatePath(ADDON_PROFILE)
ADDON_NAME = ADDON.getAddonInfo("name")
VERSION = ADDON.getAddonInfo("version")
login_api = 'https://api.fshare.vn/api/user/login'
profile_api = 'https://api.fshare.vn/api/user/get'
download_api = "https://api.fshare.vn/api/session/download"

useragent = 'kodivietmediaf-K58W6U'
domainfs = ADDON.getSetting('domainforfs')#domain mail
username = ADDON.getSetting('fshare_username')
password = ADDON.getSetting('fshare_password')



def debug(text):
    filename = os.path.join(PROFILE_PATH, "fshare.dat")
    if not os.path.exists(filename):
        with open(filename, "w+", encoding="utf-8") as f:
            f.write(text)
    else:
        with open(filename, "a", encoding="utf-8") as f:
            f.write(text + '\n')

def login():
    
    domainfs = ADDON.getSetting('domainforfs')#domain mail
    username = ADDON.getSetting('fshare_username')
    password = ADDON.getSetting('fshare_password')
    if not username or not password:
        alert("Bạn chưa nhập tài khoản Fshare. Nhập thông tin tài khoản")
        ADDON.openSettings()
    if not "@" in username:
        username = username+domainfs
    username = username.strip()
    password = password.strip()
    payload = '{"app_key":"dMnqMMZMUnN5YpvKENaEhdQQ5jxDqddt","user_email":"'+username+'","password":"'+password+'"}'
    headers = {'cache-control': "no-cache", 'User-Agent': 'kodivietmediaf-K58W6U'}
    r = requests.post('https://api.fshare.vn/api/user/login', data=payload, headers=headers, verify=False)
    jStr = json.loads(r.content)
    msg = jStr['msg']
    notify(msg)
    if r.status_code == 406:
        alert("Account chưa được kích hoạt. Bạn vào e-mail rồi kíchh hoạt tài khoản")
    if r.status_code == 409:
        alert("Tài khoản đã bị khoá login")
    if r.status_code == 410:
        alert("Tài khoản đã bị khoá")
    if r.status_code == 424:
        alert("Tài khoản đã bị khoá do nhập sai mật khẩu quá 3 lần. Kiểm tra thông tin và đợi 10 phút sau thử lại\nE-mail: [COLOR yellow]%s[/COLOR]\nPassword: [COLOR yellow]%s[/COLOR]" % (username,password))
        exit()
    if r.status_code == 403:
        image_path = "https://i.imgur.com/AfXfxGx.png"
        xbmc.executebuiltin('ShowPicture(%s)'%(image_path))
    if r.status_code == 405:
        line = "Có thể đã nhập sai email hoặc mật khẩu.\n"
        line += "[COLOR yellow]Email:[/COLOR] %s\n" % username
        line += "[COLOR yellow]Mật khẩu:[/COLOR] %s\n" % password
        line += "[I]Đừng cố thử lại. Nếu mới cài addon hãy khởi động lại thiết bị.[/I]"
        alert(line)
        exit()
        
    if r.status_code == 200:
        token = jStr['token']
        session_id = jStr['session_id']
        ADDON.setSetting(id="tokenfshare",value=token)
        ADDON.setSetting(id="sessionfshare",value=session_id)
        current_time = int(time.time())
        timenow = str(current_time)
        ADDON.setSetting(id="timelog",value=timenow)
        return(token,session_id)
def logout():
    header = {'Cookie' : 'session_id=' + session_id}
    r = requests.get('https://api.fshare.vn/api/user/logout',headers=header)

def getUserInfo(token,session_id):
    headers = {'useragent': useragent, 'Cookie': 'session_id=%s' % session_id}
    r = requests.get("https://api.fshare.vn/api/user/get",headers=headers, verify=False)
    jstr = json.loads(r.content)
    expiredDate = jstr["expire_vip"]
    point = jstr['totalpoints']
    mail = jstr['email']
    acc_type = jstr['account_type']
    webspace = float(jstr['webspace']) / float(1073741824)
    webspace_used = '{0:.2f}'.format(float(jstr['webspace_used']) / float(1073741824))
    line = 'E-mail: [COLOR yellow]%s[/COLOR] - ' % mail
    line += 'Loại tài khoản: [COLOR yellow]%s[/COLOR]\n' % acc_type
    line += 'Point: [COLOR yellow]%s[/COLOR]\n' % point
    line += 'Dung lượng lưu trữ: [COLOR yellow]%s Gb[/COLOR] / ' % webspace
    line += 'Đã sử dụng [COLOR yellow]%s Gb[/COLOR]\n' % webspace_used
    alert(line, title='Fshare vip - [COLOR yellow]zalo.me/0915134560[/COLOR]')
def get_download_link(token, session_id, link, max_reset_attempts=2):
    payload = json.dumps({"zipflag": 0, "url": link, "password": "", "token": token})
    headers = {
        'Content-Type': 'application/json',
        'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36',
        'User-Agent': 'kodivietmediaf-K58W6U',
        'Authorization': 'Bearer efdf39c90189ddfbff339ae344c28db5f6c11885',
        'Cookie': 'session_id=' + session_id
    }
    def retrieve_download_link(reset_attempts=0):
        r = requests.post(download_api, headers=headers, data=payload, verify=False)
        jstr = json.loads(r.content)
        if r.status_code == 404:
            alert("Link này không tồn tại hoặc bị xoá")
        if r.status_code == 201:
            alert("Tài khoản chưa đăng nhập")
        if r.status_code == 471:
            reset_code = ADDON.getSetting('reset_code')
            if len(reset_code.strip()) > 5:
                resetfs.cvl(reset_code)
                if reset_attempts < max_reset_attempts:
                    return retrieve_download_link(reset_attempts + 1)
                else:
                    alert("Đã thử quá nhiều lần reset. Liên hệ Fanpage Fshare.vn")
            else:
                alert("Phiên tải quá nhiều. Cần xoá phiên tải.\nLiên hệ Fanpage Fshare.vn")
        if r.status_code == 200:
            link_download = jstr["location"]
            return link_download

    return retrieve_download_link()
def homeFolder(token,session_id):
    url = "https://api.fshare.vn/api/fileops/list?pageIndex=0&dirOnly=0&limit=100&path="
    headers = {
          'useragent': 'kodivietmediaf-K58W6U',
          'Cookie': 'session_id=%s' % session_id
        }
    r = requests.get(url, headers=headers,verify=False)
    jstr = json.loads(r.content)
    for i in jstr:
        name = jstr["name"]
        linkcode = jstr["linkcode"]
        ftype = jstr["type"]
        if ftype == 0:isFolder = True
        if ftype == 1:isFolder = False
        size = jstr["size"]
        
        item = xbmcgui.ListItem(label=name, path=link)
        item.setInfo(type='Video', infoLabels={'size': size})
        item.setArt({'thumb': f_icon, 'icon': f_icon})
        xbmcplugin.addDirectoryItem(handle=int(sys.argv[1]), url=link, listitem=item, isFolder=isFolder)
    xbmcplugin.endOfDirectory(int(sys.argv[1]))


    

def getListFolder(token,session_id,link):
    f_icon = "https://i.imgur.com/ytoQpHG.png"
    payload = json.dumps({
          "token": token,
          "url": link,
          "dirOnly": 0,
          "pageIndex": 0,
          "limit": 100
        })
    headers = {
          'Content-Type': 'application/json',
          'useragent': useragent,
          'Cookie': 'session_id=%s' % session_id
        }
    r = requests.post("https://api.fshare.vn/api/fileops/getFolderList", headers=headers, data=payload, verify=False)
    jstr = json.loads(r.content)
    
    context_menu_items = []
    for i in jstr:
        name = jstr["name"]
        furl = jstr["furl"]
        link = 'plugin://plugin.video.vietmediaF?action=play&url=%s' % furl
        ftype = jstr["type"]
        if ftype == 0:isFolder = True
        if ftype == 1:isFolder = False
        size = jstr["size"]
        item = xbmcgui.ListItem(label=name, path=link)
        item.setInfo(type='Video', infoLabels={'size': size})
        item.setArt({'thumb': f_icon, 'icon': f_icon})
        context_menu_items.append(('Thêm vào yêu thích Fshare', 'RunPlugin(%s?action=play&d=__addtofav__&url=%s)' % (sys.argv[0], link)))
        item.addContextMenuItems(context_menu_items)
        xbmcplugin.addDirectoryItem(handle=int(sys.argv[1]), url=link, listitem=item, isFolder=isFolder)
    xbmcplugin.endOfDirectory(int(sys.argv[1]))

def fileInFolder(url):
    token,session_id = check_session()
    headers = {
        'Content-Type': 'application/json',
        'User-Agent': 'kodivietmediaf-K58W6U',
        'Fshare-Session-Id': session_id
    }
    json_data = {'token': token,'url': url}
    r = requests.post('https://api.fshare.vn/api/fileops/getTotalFileInFolder',headers=headers,json=json_data,verify=False)
    if (r.status_code) == 200:
        jsdata = json.loads(r.content)
        return(jsdata["total"])
    else:
        return "-"
        
def isvalid(session_id):
    headers = {'useragent': 'kodivietmediaf-K58W6U', 'Cookie': 'session_id=%s' % session_id}
    try:
        r = requests.get("https://api.fshare.vn/api/user/get", headers=headers, verify=False)
        r.raise_for_status()  
        jStr = r.json()  
    except requests.exceptions.RequestException as e:
        debug(f"Request failed: {e}")
        return False
    except json.JSONDecodeError as e:
        debug(f"JSON decode failed: {e}")
        return False

    if "error" in jStr:
        #debug(f"API error: {jStr['error']}")
        return False

    account_type = jStr.get('account_type')
    if not account_type:
        return False
    
    if account_type == "Member":
        alert("Tài khoản có thể hết hạn, cần nâng cấp. Liên hệ Zalo: 0915134560")
    
    if r.status_code == 200:
        #notify("Valid session")
        return True

    return False
def getAccFshare():
    username = ADDON.getSetting('fshare_username')
    password = ADDON.getSetting('fshare_password')
    if not username or not password:
        alert("Bạn chưa nhập tài khoản Fshare.")
        ADDON.openSettings()
        username = ADDON.getSetting('fshare_username')
        password = ADDON.getSetting('fshare_password')
    if "@" not in username:
        domainforfs = ADDON.getSetting('domainforfs')
        username = username + domainforfs
    
    return (username,password)
def getBackupAcc():
    username_backup = ADDON.getSetting('username_backup')
    password_backup = ADDON.getSetting('password_backup')
    backup_option_fshare = ADDON.getSetting('backup_option_fshare')
    if backup_option_fshare == "true":
            username_backup,password_backup = getAccFshare()
            
    else:
        if not username_backup or not password_backup:
            alert("Bạn chưa nhập [COLOR yellow]tài khoản Backup[/COLOR]. Nhập thông tin tài khoản")
            ADDON.openSettings()
            backup_option_fshare = ADDON.getSetting('backup_option_fshare')
            if backup_option_fshare == "true":
                username_backup,password_backup = getAccFshare()
                
            else:
                username_backup = ADDON.getSetting('username_backup')
                password_backup = ADDON.getSetting('password_backup')
                if "@" not in username_backup:
                    domainforbackup = ADDON.getSetting('domainforbackup')
                    username_backup = username_backup+domainforbackup
                    
    return (username_backup,password_backup)

def updateAcc():
    session_id = ADDON.getSetting("session_id")
    if isvalid(session_id):
        logout()
    token, session_id = login()
    vDialog.create(ADDON_NAME+" " +VERSION, "Kiểm tra tài khoản thông tin tài khoản")
    header = {'Cookie': 'session_id=' + session_id}
    r = requests.get('https://api.fshare.vn/api/user/get', headers=header, verify=False)
    jstr = json.loads(r.content)
    acc_type = jstr['account_type']
    if "Download" in acc_type:
        acc_type = "Vip-Download"
    
    if "Bundle" in acc_type or "Forever" in acc_type or "ADSL2plus" in acc_type:
        expiredDate = str("4102444799")
    else:
        expiredDate = jstr["expire_vip"]
    point = jstr['totalpoints']
    mail = jstr['email']
    
    webspace = float(jstr['webspace']) / float(1073741824)
    webspace_used = '{0:.2f}'.format(float(jstr['webspace_used']) / float(1073741824))
    filename = os.path.join(PROFILE_PATH, 'expired.dat')
    if not os.path.exists(filename):
        with open(filename, "w+") as f:
            f.write(expiredDate)
    else:
        with open(filename, "wb") as f:
            f.write(expiredDate.encode("UTF-8"))
    if acc_type == "Member":
        #line="Tài khoản của bạn hiện tại là [COLOR yellow]MEMBER[/COLOR]. Để nâng cấp VIP vui lòng liên hệ Zalo số [COLOR yellow]0915134560[/COLOR]"
        #alert(line)
        image_path = "https://i.imgur.com/NNFY9qW.png"
        xbmc.executebuiltin('ShowPicture(%s)'%(image_path))
        
    else:
        if "Download" in acc_type:
            acc_type = "Vip-Download"
            webspace = '0'
            webspace_used = '0'
        
        
        line = 'E-mail: [COLOR yellow]%s[/COLOR] - ' % mail
        line += 'Loại tài khoản: [COLOR yellow]%s[/COLOR]\n' % acc_type
        line += 'Point: [COLOR yellow]%s[/COLOR]\n' % point
        line += 'Dung lượng lưu trữ: [COLOR yellow]%s Gb[/COLOR] / ' % webspace
        line += 'Đã sử dụng [COLOR yellow]%s Gb[/COLOR]\n' % webspace_used
        vDialog.close()
        alert(line, title='Fshare vip - [COLOR yellow]zalo.me/0915134560[/COLOR]')


def check_session():
    username = ADDON.getSetting('fshare_username')
    if not "@" in username:
        username = username+domainfs
    password = ADDON.getSetting('fshare_password')
    token = ADDON.getSetting('tokenfshare')
    session_id = ADDON.getSetting('sessionfshare')
    timelog = ADDON.getSetting('timelog')
    if not username or not password:
        alert("Bạn chưa nhập tài khoản Fshare. Nhập thông tin tài khoản")
        ADDON.openSettings()
    if not token or not session_id:
        token, session_id = login()
        ADDON.setSetting(id="tokenfshare", value=token)
        ADDON.setSetting(id="sessionfshare", value=session_id)
    elif not isvalid(session_id):
        token, session_id = login()
        ADDON.setSetting(id="tokenfshare", value=token)
        ADDON.setSetting(id="sessionfshare", value=session_id)
    return (token,session_id)
def get_fshare_file_info(url):
    if "plugin" in url:
        regex = r"url=([^&]+)"
        match = re.search(regex,url)
        if match:
            url = match.group(1)
    token,session_id = check_session()
    data   = '{"token" : "%s", "url" : "%s"}' % (token,url)
    header = {'User-Agent': useragent,'Cookie' : 'session_id=' + session_id }
    r = requests.post('https://118.69.164.19/api/fileops/get',headers=header,data=data,verify=False)
    try:
        jstr = json.loads(r.content)
        name = jstr['name']
        file_type=jstr['file_type']
        size=jstr['size']
        
        return(name,file_type,size)
    except json.JSONDecodeError:
        return ("File không tồn tại","","")
