import requests
from bs4 import BeautifulSoup
import re, os, json
import hashlib
import urllib.parse
from resources import fshare, cache_utils
import urlquick, htmlement
from addon import alert, notify, TextBoxes, ADDON, ADDON_ID, ADDON_PROFILE, LOG, PROFILE
import xbmcgui, xbmc, xbmcvfs
from concurrent.futures import ThreadPoolExecutor
import threading
from xbmcgui import DialogProgress
from collections import OrderedDict
PROFILE_PATH = xbmcvfs.translatePath(ADDON_PROFILE)
CACHE_PATH = xbmcvfs.translatePath("special://temp")
addon_url = "plugin://{}/".format(ADDON_ID)
def search(page, query):
    search_url = "https://thuvienhd.xyz/page/%s?s=%s" % (page, query)
    
    success = False
    for _ in range(3):
        try:
            response = requests.get(search_url, verify=False)
            success = True
            break
        except Exception as e:
            alert("Không có kết quả hiển thị. Hết")
            return
    
    if not success:
        alert("Không lấy được nội dung từ trang web")
        return
    
    soup = BeautifulSoup(response.content, "html.parser")
    result_items = soup.find_all('div', class_='result-item')
    items = []
    
    for result_item in result_items:
        img_src = result_item.find('img')['src']
        href = result_item.find('a')['href']
        name = result_item.find('div', class_='title')
        if name:
            name = name.text.strip()
        else:
            name = ""
        
        year = result_item.find('span', class_='year')
        if year:
            year = year.text.strip()
            name = name +" (%s)" % year
        else:
            name = name
        
        info = result_item.find('div', class_='contenido')
        if info:
            info = info.text.strip()
        else:
            info = ""
        
        item = {
            "label": name,
            "is_playable": False,
            "path": addon_url + "browse&url="+href,
            "thumbnail": img_src,
            "icon": img_src,
            "label2": "",
            "info": {"plot": info},
            "art": {"fanart": img_src}
        }
        
        items.append(item)
    
    # Next page
    next_page = int(page) + 1
    next_page_url = "https://thuvienhd.xyz/page/%s?s=%s" % (next_page, query)
    response = urlquick.head(next_page_url)
    status_code = response.status_code
    
    if status_code == 200:
        next_page_url = addon_url + "browse&url=" + next_page_url
        nextpage = {
            "label": '[COLOR yellow]Trang %s[/COLOR] ' % next_page,
            "is_playable": False,
            "path": next_page_url,
            "thumbnail": 'https://i.imgur.com/yCGoDHr.png',
            "icon": "https://i.imgur.com/yCGoDHr.png",
            "label2": "",
            "info": {"plot": "Trang tiếp TVHD"}
        }
        items.append(nextpage)
    
    data = {"content_type": "episodes", "items": items}
    return data



def getlink(url):
    def getlink_(url):
        success = False
        for _ in range(3):
            try:
                response = requests.get(url, verify=False)
                success = True
                break
            except Exception as e:
                xbmcgui.Dialog().notification('Lỗi', 'Không lấy được nội dung từ web', xbmcgui.NOTIFICATION_ERROR)
        soup = BeautifulSoup(response.content, "html.parser")
        img_tag = soup.find("div", class_="poster").find("img")
        img_path = img_tag["src"]
        a_tag = soup.find("span", class_="box__download").find("a")
        href = a_tag["href"]
        response = requests.get(href)
        soup = BeautifulSoup(response.content, "html.parser")
        link_tags = soup.select('table.post_table a[href*="fshare.vn"]')
        links = [link['href'] for link in link_tags]
        items = []
        total_links = len(links)
        dialog = DialogProgress()
        dialog.create("Processing", "Lấy dữ liệu...")
        
        for index, href in enumerate(links, 1):
            name, file_type, size_file = fshare.get_fshare_file_info(href)
            item = {}
            if "folder" in href:
                playable = False
            else:
                playable = True
            item["label"] = name
            item["is_playable"] = playable
            item["path"] = 'plugin://plugin.video.vietmediaF?action=browse&url=%s' % href
            item["thumbnail"] = img_path
            item["icon"] = img_path
            item["label2"] = ""
            item["info"] = {'plot': '', 'size': size_file}
            item["art"] = {'fanart':img_path }
            items.append(item)
            dialog.update(0,"Link: %d/%d" % (index, total_links))

        dialog.close()
        data = {"content_type": "movies", "items": ""}
        data.update({"items": items})
        return data
    # Kiểm tracache
    cache_filename = hashlib.md5(url.encode()).hexdigest() + '_cache.json'
    cache_path = os.path.join(CACHE_PATH, cache_filename)
    if cache_utils.check_cache(cache_path):
        # Đọc nội dung từ file cache
        with open(cache_path, 'r') as cache_file:
            cache_content = json.load(cache_file)
            #notify("cached")
        return cache_content
    else:
        data = getlink_(url)
        with open(cache_path, "w") as f:
            json.dump(data, f)
            #notify("fresh data")
        return data
def listGenre(url):
    
    def listGenre_(url):
        
        success = False
        headers = {
            "authority": "www.thuvienhd.xyz",
            "user-agent": "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/115.0.0.0 Safari/537.36 Edg/115.0.0.0"
        }
        '''
        for _ in range(3):
            try:
                response = urlquick.get(url, headers=headers, max_age=60*60)
                success = True
                break
            except Exception as e:
                xbmcgui.Dialog().notification('Lỗi', 'Không lấy được nội dung từ web', xbmcgui.NOTIFICATION_ERROR)
        '''
        response = requests.get(url, headers=headers, verify=False)
        html_content = response.content
        soup = BeautifulSoup(html_content, "html.parser")
        articles = soup.find_all("article", class_="item movies")
        
        items = []
        for article in articles:
            
            img = article.find("img").get("src")
            fanart = img
            quality_slider = article.find("span", class_="quality_slider").text if article.find("span", class_="quality_slider") else ""
            quality_slider = " [COLOR yellow]%s[/COLOR] " % quality_slider
            language = article.find("div", class_="language").text if article.find("div", class_="language") else ""
            language = "[COLOR yellow] %s[/COLOR]" % language
            href = article.find("a").get("href") if article.find("a") else ""
            data = article.find('div', class_='data')
            year = data.find('span').text.strip() if data else ''
            name = article.find("div", class_="title").text if article.find("div", class_="title") else ""
            name = name.strip()
            imdb = article.find("span", class_="imdb").text if article.find("span", class_="imdb") else ""
            description = article.find("div", class_="texto").text if article.find("div", class_="texto") else ""
            description = "[COLOR yellow]%s[/COLOR] " % imdb + "\n"+description
            name = name + " (" + year + ")" + " " +  quality_slider + language
            
            genre_div = article.find("div", class_="genres")
            if genre_div:
                links = genre_div.find_all('a')
                genre = '/'.join(link.text.strip() for link in links)
            else:
                genre = "N/A"
            
            item = {}
            item["label"] = name
            item["is_playable"] = False
            item["path"] = addon_url + "browse&url=" + href
            item["thumbnail"] = img
            item["icon"] = img
            item["label2"] = "VMF"
            item["info"] = {'plot': description, 'genre': genre}
            item["art"] = {'fanart': fanart}
            
            items += [item]
        try:
            pagination = soup.find("div", class_="pagination")
            if pagination:
                current_page_span = pagination.find("span", class_="current")
                current_page = int(current_page_span.text.strip())
                next_page = current_page + 1
                
                if "page" in url:
                    print(url)
                    match = re.search(r"(.*)\/page",url)
                    if match:
                        next_url = match.group(1)
                        
                else:next_url = url
                next_url = "%s/page/%s" % (next_url,next_page)
                next_page_url = addon_url + "browse&url=vmf"+next_url
                nextpage = {"label": '[COLOR yellow]Trang %s[/COLOR]' % next_page, "is_playable": False, "path": next_page_url, "thumbnail": 'https://i.imgur.com/yCGoDHr.png', "icon": "https://i.imgur.com/yCGoDHr.png", "label2": "", "info": {'plot': 'Trang tiếp'}}
                items.append(nextpage)
        except:items = items
        data = {"content_type": "movies", "items": ""}
        data.update({"items": items})
        return data
    dialog = xbmcgui.DialogProgress()
    dialog.create('Đang lấy dữ liệu', 'Vui lòng đợi...')
    # Kiểm tracache
    cache_filename = hashlib.md5(url.encode()).hexdigest() + '_cache.json'
    cache_path = os.path.join(CACHE_PATH, cache_filename)
    if cache_utils.check_cache(cache_path):
        # Đọc nội dung từ file cache
        with open(cache_path, 'r') as cache_file:
            cache_content = json.load(cache_file)
            #notify("cached")
        return cache_content
    else:
        data = listGenre_(url)
        with open(cache_path, "w") as f:
            json.dump(data, f)
            #notify("fresh data")
        return data
   

def listMovie(url):
    
    def listMovie_(url):
        success = False
        for _ in range(3):
            try:
                response = requests.get(url, verify=False)
                success = True
                break
            except Exception as e:
                xbmcgui.Dialog().notification('Lỗi', 'Không lấy được nội dung từ web', xbmcgui.NOTIFICATION_ERROR)
        soup = BeautifulSoup(response.content, "html.parser")
        divs = soup.find_all("article", {"id": lambda x: x and x.startswith("post-")})
        items = OrderedDict()
        lock = threading.Lock()

        def get_info(href):
            try:
                response = requests.get(href,verify=False)
                soup = BeautifulSoup(response.content, "html.parser")
                
                genre_div = soup.find("div", class_="sgeneros")
                if genre_div:
                    links = genre_div.find_all('a')
                    genre = '/'.join(link.text.strip() for link in links)
                else:
                    genre = "N/A"
                    
                data_div = soup.find('div', class_='data')
                try:
                    name_vie = data_div.find('h1').text.strip()
                except AttributeError:
                    try:
                         name_vie = data_div.find('h3').text.strip()
                    except AttributeError:
                            name_vie = ''
                try:
                    name_eng = soup.find('h2', class_='title-en').text.strip()
                    name_eng = name_eng.replace("|", "-")
                    name = name_vie + " - " + name_eng
                except:
                    name = name_vie
                name = name.replace("|","-")
                try:
                    description = soup.find('div', class_='cnnn').text.strip()
                    description = description.replace("thuvienhd.xyz", "")
                    description = description.strip()
                    description = description.replace("https://","")
                except:description: description = ''
                
                return (name, description, genre)
            except Exception as e:
                alert(f"get_info: {e}")    

        def process_div(div):
            try:
                img_tag = div.find('img')
                alt = img_tag['alt']
                img = img_tag['src']
                try:
                    quality_slider = div.find('span', class_='quality_slider')
                    quality = quality_slider.text 
                except: quality= ''
                try:
                    language_span = div.find('span', class_='kbd-quality')
                    language = language_span.text 
                except: language = ''
                data_div = div.find('div', class_='data')
                href = data_div.find('a')['href']
                '''
                try:
                    year_span = data_div.find('span')
                    year = year_span.text.strip() 
                except: year = ''
                '''
                name, description,genre = get_info(href)
                extra_info = f"({quality} {language})".strip()
                extra_info = extra_info.replace(' )',')')
                name = f"{name.strip()} {extra_info}"
                genre = ''
                item = {}
                item["label"] = name
                item["is_playable"] = False
                item["path"] = addon_url + "browse&url=" + href
                item["thumbnail"] = img
                item["icon"] = img
                item["label2"] = "VMF"
                item["info"] = {'plot': description, 'genre': genre}

                with lock:
                    items[div] = item
            except Exception as e:
                TextBoxes("Error processing div", e)

        class CustomThreadPoolExecutor(ThreadPoolExecutor):
            def __init__(self, max_workers):
                super().__init__(max_workers=max_workers)
                self._work_lock = threading.Lock()

            def submit(self, fn, *args, **kwargs):
                with self._work_lock:
                    future = super().submit(fn, *args, **kwargs)
                    future.add_done_callback(self._callback)
                    return future

            def _callback(self, future):
                try:
                    future.result()
                except Exception as e:
                    print(f"Error in thread: {e}")

        with CustomThreadPoolExecutor(max_workers=len(divs)) as executor:
            executor.map(process_div, divs)

        sorted_items = [items[div] for div in divs]
        #Next page
        try:
            pagination = soup.find("div", class_="pagination")
            if pagination:
                current_page_span = pagination.find("span", class_="current")
                current_page = int(current_page_span.text.strip())
                next_page = current_page + 1
                
                if "trending" in url:
                    next_url = "https://thuvienhd.xyz/trending/page/%s?get=movies" % next_page
                    
                else:
                    if "page" in url:
                        match = re.search(r"(.*)\/page",url)
                        if match:
                            next_url = match.group(1)
                            
                    else:
                        next_url = url
                    
                    next_url = "%s/page/%s" % (next_url,next_page)
                next_page_url = addon_url + "browse&url=vmf"+next_url
                nextpage = {"label": '[COLOR yellow]Trang %s [/COLOR]' % str(next_page), "is_playable": False, "path": next_page_url, "thumbnail": 'https://i.imgur.com/yCGoDHr.png', "icon": "https://i.imgur.com/yCGoDHr.png", "label2": "", "info": {'plot': 'Trang tiếp'}}
                sorted_items.append(nextpage)
        except:pass
        data = {"content_type": "movies", "items": ""}
        data.update({"items": sorted_items})
        return(data)
    dialog = xbmcgui.DialogProgress()
    dialog.create('Đang lấy dữ liệu', 'Vui lòng đợi...')
    # Kiểm tracache
    cache_filename = hashlib.md5(url.encode()).hexdigest() + '_cache.json'
    cache_path = os.path.join(CACHE_PATH, cache_filename)
    if cache_utils.check_cache(cache_path):
        # Đọc nội dung từ file cache
        with open(cache_path, 'r') as cache_file:
            cache_content = json.load(cache_file)
            #notify("cached")
        return cache_content
    else:
        data = listMovie_(url)
        with open(cache_path, "w") as f:
            json.dump(data, f)
            #notify("fresh data")
        return data
def receive(url):
    
    if "menu" in url:
        names = ['Tìm kiếm','Mới nhất','Xu hướng','Phim lẻ','Phim bộ','Phim lẻ thể loại','Phim Bộ theo quốc gia','Phim 18+','Phim H265','Phim TVB','Phim Thuyết Minh','Phim Lồng Tiếng']
        links = [addon_url+"browse&url=https://thuvienhd.xyz/timkiem",
                addon_url+"browse&url=https://thuvienhd.xyz/recent",
                addon_url+"browse&url=https://thuvienhd.xyz/trending?get=movies",
                addon_url+"browse&url=vmfhttps://thuvienhd.xyz/genre/phim-le",
                addon_url+"browse&url=vmfhttps://thuvienhd.xyz/genre/series",
                addon_url+"browse&url=https://thuvienhd.xyz/genre/theloai",
                addon_url+"browse&url=vmfhttps://thuvienhd.xyz/genre/quocgia",
                addon_url+"browse&url=vmfhttps://thuvienhd.xyz/genre/18",
                addon_url+"browse&url=vmfhttps://thuvienhd.xyz/genre/h265",
                addon_url+"browse&url=https://thuvienhd.xyz/genre/tvb",
                addon_url+"browse&url=vmfhttps://thuvienhd.xyz/genre/thuyet-minh-tieng-viet",
                addon_url+"browse&url=vmfhttps://thuvienhd.xyz/genre/long-tieng-tieng-viet"]
        items = []
        
        for name, link in zip(names,links):
            if "phim-le" in link:
                fanart = "https://thuvienhd.xyz/wp-content/themes/dooplay/images/banner_phimle.jpg"
            elif "genre/18" in link:
                fanart = "https://thuvienhd.xyz/wp-content/themes/dooplay/images/phim18.jpg"
            elif "genre/series" in link:
                fanart = "https://thuvienhd.xyz/wp-content/themes/dooplay/images/banner_series.jpg"
            else:fanart = "https://i.imgur.com/dGv6Non.jpg"
            item = {}
            item["label"] = name
            item["is_playable"] = False
            item["path"] = link
            item["thumbnail"] = "https://i.imgur.com/5dFJGyW.png"
            item["icon"] = "https://i.imgur.com/5dFJGyW.png"
            item["label2"] = ""
            item["info"] = {'plot': 'Các phim trên thuvienhd'}
            item["art"] = {'fanart': fanart}
            items += [item]
        data = {"content_type": "movies", "items": ""}
        data.update({"items": items})
        return data
    elif "trending" in url or "recent" in url or ("recent" in url and "vmf" in url):
        
        if "vmf" in url:
            url = url.replace("vmf","")
        match = re.search(r"url=(.*)",url)
        if match:
            url = match.group(1)
        try:data = listMovie(url)
        except Exception as e:
                alert(f"Error processing div: {e}")
        return data
    elif "theloai" in url:
        names = ['Hành Động', 'Võ Thuật','Viễn Tưởng', 'Kinh Dị', 'Hàn Quốc', '3D', '4K', 'Ấn Độ', 'Hài', 'Cao Bồi', 'Chiến Tranh', 'Chính Kịch', 'Cổ Trang', 'Gia Đình', 'Giáng Sinh', 'Hình Sự', 'Phim Hoạt Hình', 'Hongkong', 'Huyền Bí', 'Lãng Mạn', 'Lịch Sử', 'Nhạc Kịch', 'Phiêu Lưu', 'Phim', 'Phim Tài Liệu', 'Rùng Rợn', 'Tâm Lý', 'Thần Thoại', 'Thể Thao', 'Thiếu Nhi', 'Tiểu Sử', 'Tình Cảm', 'Trinh Thám', 'Trung Quốc']
        links = ['vmfhttps://thuvienhd.xyz/genre/action',
            'vmfhttps://thuvienhd.xyz/genre/vo-thuat-phim-2',
            'vmfhttps://thuvienhd.xyz/genre/sci-fi', 'vmfhttps://thuvienhd.xyz/genre/horror', 'vmfhttps://thuvienhd.xyz/genre/korean', 'vmfhttps://thuvienhd.xyz/genre/3d', 'vmfhttps://thuvienhd.xyz/genre/4k', 'vmfhttps://thuvienhd.xyz/genre/india', 'vmfhttps://thuvienhd.xyz/genre/comedy', 'vmfhttps://thuvienhd.xyz/genre/western', 'vmfhttps://thuvienhd.xyz/genre/war', 'vmfhttps://thuvienhd.xyz/genre/chinh-kich', 'vmfhttps://thuvienhd.xyz/genre/co-trang-phim', 'vmfhttps://thuvienhd.xyz/genre/gia-dinh', 'vmfhttps://thuvienhd.xyz/genre/giang-sinh', 'vmfhttps://thuvienhd.xyz/genre/crime', 'vmfhttps://thuvienhd.xyz/genre/animation', 'vmfhttps://thuvienhd.xyz/genre/hongkong', 'vmfhttps://thuvienhd.xyz/genre/mystery', 'vmfhttps://thuvienhd.xyz/genre/romance', 'vmfhttps://thuvienhd.xyz/genre/history', 'vmfhttps://thuvienhd.xyz/genre/nhac-kich', 'vmfhttps://thuvienhd.xyz/genre/adventure', 'vmfhttps://thuvienhd.xyz/genre/phim', 'vmfhttps://thuvienhd.xyz/genre/documentary', 'vmfhttps://thuvienhd.xyz/genre/thriller', 'vmfhttps://thuvienhd.xyz/genre/drama', 'vmfhttps://thuvienhd.xyz/genre/fantasy', 'vmfhttps://thuvienhd.xyz/genre/the-thao', 'vmfhttps://thuvienhd.xyz/genre/family', 'vmfhttps://thuvienhd.xyz/genre/tieu-su', 'vmfhttps://thuvienhd.xyz/genre/tinh-cam', 'vmfhttps://thuvienhd.xyz/genre/trinh-tham', 'vmfhttps://thuvienhd.xyz/genre/trung-quoc-series']
        items = []
        for name, link in zip(names,links):
            item = {}
            item["label"] = name
            item["is_playable"] = False
            item["path"] = addon_url + "browse&url="+link
            item["thumbnail"] = "https://i.imgur.com/5dFJGyW.png"
            item["icon"] = "https://i.imgur.com/5dFJGyW.png"
            item["label2"] = ""
            item["info"] = {'plot': ''}
            item["art"] = {'fanart': "https://i.imgur.com/dGv6Non.jpg"}
            items += [item]
        data = {"content_type": "episodes", "items": ""}
        data.update({"items": items})
        return data
    elif "quocgia" in url:
        links =  ['vmfhttps://thuvienhd.xyz/genre/phim-bo-viet-nam',
        'vmfhttps://thuvienhd.xyz/genre/us-tv-series',
        'vmfhttps://thuvienhd.xyz/genre/korean-series', 
        'vmfhttps://thuvienhd.xyz/genre/phim-bo-trung-quoc',
        'vmfhttps://thuvienhd.xyz/genre/hongkong-series',
        'vmfhttps://thuvienhd.xyz/genre/phi-bo-nigeria', 'vmfhttps://thuvienhd.xyz/genre/phim-bo-a-rap', 'vmfhttps://thuvienhd.xyz/genre/phim-bo-ai-cap', 'vmfhttps://thuvienhd.xyz/genre/phim-bo-ai-nhi-lan-ireland', 'vmfhttps://thuvienhd.xyz/genre/phim-bo-an-do', 'vmfhttps://thuvienhd.xyz/genre/phim-bo-anh', 'vmfhttps://thuvienhd.xyz/genre/phim-bo-ao', 'vmfhttps://thuvienhd.xyz/genre/phim-bo-argentina', 'vmfhttps://thuvienhd.xyz/genre/phim-bo-australia', 'vmfhttps://thuvienhd.xyz/genre/phim-bo-ba-lan', 'vmfhttps://thuvienhd.xyz/genre/phim-bo-bi', 'vmfhttps://thuvienhd.xyz/genre/phim-bo-bo-dao-nha', 'vmfhttps://thuvienhd.xyz/genre/phim-bo-brazil', 'vmfhttps://thuvienhd.xyz/genre/phim-bo-canada', 'vmfhttps://thuvienhd.xyz/genre/phim-bo-chile', 'vmfhttps://thuvienhd.xyz/genre/phim-bo-colombia', 'vmfhttps://thuvienhd.xyz/genre/phim-bo-dai-loan', 'vmfhttps://thuvienhd.xyz/genre/phim-bo-dan-mach', 'vmfhttps://thuvienhd.xyz/genre/phim-bo-duc', 'vmfhttps://thuvienhd.xyz/genre/phim-bo-ha-lan',  'vmfhttps://thuvienhd.xyz/genre/phim-bo-iceland', 'vmfhttps://thuvienhd.xyz/genre/phim-bo-ireland', 'vmfhttps://thuvienhd.xyz/genre/phim-bo-israel', 'vmfhttps://thuvienhd.xyz/genre/phim-bo-jordan', 'vmfhttps://thuvienhd.xyz/genre/phim-bo-mexico',  'vmfhttps://thuvienhd.xyz/genre/phim-bo-na-uy', 'vmfhttps://thuvienhd.xyz/genre/phim-bo-nam-phi', 'vmfhttps://thuvienhd.xyz/genre/phim-bo-new-zealand', 'vmfhttps://thuvienhd.xyz/genre/phim-bo-nga', 'vmfhttps://thuvienhd.xyz/genre/phim-bo-nhat-ban', 'vmfhttps://thuvienhd.xyz/genre/phim-bo-phan-lan', 'vmfhttps://thuvienhd.xyz/genre/phim-bo-phap', 'vmfhttps://thuvienhd.xyz/genre/phim-bo-philippines', 'vmfhttps://thuvienhd.xyz/genre/phim-bo-romania', 'vmfhttps://thuvienhd.xyz/genre/phim-bo-singapo', 'vmfhttps://thuvienhd.xyz/genre/phim-bo-tay-ban-nha', 'vmfhttps://thuvienhd.xyz/genre/phim-bo-thai-lan', 'vmfhttps://thuvienhd.xyz/genre/phim-bo-tho-nhi-ky', 'vmfhttps://thuvienhd.xyz/genre/phim-bo-thuy-dien',   'vmfhttps://thuvienhd.xyz/genre/phim-bo-y']
        names = ['Phim Bộ Việt Nam','Phim Bộ Mỹ','Phim Bộ Hàn','Phim Bộ Trung Quốc','Phim Bộ Hongkong','Phi Bộ Nigeria', 'Phim Bộ Ả Rập', 'Phim Bộ Ai Cập', 'Phim Bộ Ái Nhĩ Lan (Ireland', 'Phim Bộ Ấn Độ', 'Phim bộ Anh', 'Phim Bộ Áo', 'Phim Bộ Argentina', 'Phim Bộ Australia', 'Phim Bộ Ba Lan', 'Phim Bộ Bỉ', 'Phim Bộ Bồ Đào Nha', 'Phim Bộ Brazil', 'Phim Bộ Canada', 'Phim Bộ Chile', 'Phim Bộ Colombia', 'Phim Bộ Đài Loan', 'Phim Bộ Đan Mạch', 'Phim Bộ Đức', 'Phim Bộ Hà Lan','Phim Bộ Iceland', 'Phim Bộ Ireland', 'Phim Bộ Israel', 'Phim Bộ Jordan', 'Phim Bộ Mexico',  'Phim Bộ Na Uy', 'Phim Bộ Nam Phi', 'Phim Bộ New Zealand', 'Phim Bộ Nga', 'Phim Bộ Nhật Bản', 'Phim Bộ Phần Lan', 'Phim Bộ Pháp', 'Phim Bộ Philippines', 'Phim Bộ Romania', 'Phim Bộ Singapo', 'Phim Bộ Tây Ban Nha', 'Phim Bộ Thái Lan', 'Phim Bộ Thổ Nhĩ Kỳ', 'Phim Bộ Thụy Điển', 'Phim Bộ Ý']
        items = []
        for name, link in zip(names,links):
            item = {}
            item["label"] = name
            item["is_playable"] = False
            item["path"] = addon_url + "browse&url="+link
            item["thumbnail"] = "https://i.imgur.com/5dFJGyW.png"
            item["icon"] = "https://i.imgur.com/5dFJGyW.png"
            item["label2"] = ""
            item["info"] = {'plot': ''}
            item["art"] = {'fanart': "https://i.imgur.com/dGv6Non.jpg"}
            items += [item]
        data = {"content_type": "episodes", "items": ""}
        data.update({"items": items})
        return data
    elif "timkiem" in url:
        keyboard = xbmc.Keyboard("", "Nhập tên phim")
        keyboard.doModal()
        if keyboard.isConfirmed() and keyboard.getText():
            query = keyboard.getText()
            query = urllib.parse.unquote(query)
            data = search("1",query)
            return data
        else:
            alert("Không có gì được nhập vào.")
            return
    elif "?s=" in url:
        
        current_page = re.search(r"\/page\/(\d+)",url).group(1)
        query = re.search(r"s=(.*)",url).group(1)
        data = search(current_page,query)
        return data
    elif "genre" in url:
        if "vmf" in url:
            url = url.replace("vmf","")
        
        data = listGenre(url)
        return data
    else:
        if "vmf" in url:
            url = url.replace("vmf","")
        match = re.search(r"url=(.*)",url)
        if match:
            url = match.group(1)
        data = getlink(url)
        return data