from urllib.parse import urlencode, parse_qsl, unquote, quote_plus, urlparse
from xbmcplugin import addDirectoryItem, endOfDirectory, setResolvedUrl, setContent
from xbmcaddon import Addon
import re, sys, urlquick, xbmcgui, json
addon_url = sys.argv[0]
HANDLE = int(sys.argv[1])
addon_name = Addon().getAddonInfo('name')
ICON = Addon().getAddonInfo('icon')
PATH = Addon().getAddonInfo('path')
RESOURCES = PATH + '/media/'
searchimg = RESOURCES +'search.png'
nextimg = RESOURCES + 'next.png'
UA = 'Mozilla/5.0 (Linux; Android 15; Pixel 9 Pro Build/AP4A.261212) AppleWebKit/605.1.15 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/605.1.15 EdgA/133.0.0.0'
def addDir(title, img, plot, mode, is_folder=True, **kwargs):
    kwargs = {key: json.dumps(value) if isinstance(value, list) else value for key, value in kwargs.items()}
    dir_url = f'{addon_url}?{urlencode({"mode": mode, **kwargs})}'
    list_item = xbmcgui.ListItem(label=title)
    list_item.setArt({'icon': img, 'thumb': img, 'poster': img, 'fanart': img})
    info_tag = list_item.getVideoInfoTag()
    info_tag.setTitle(title)
    info_tag.setPlot(plot)
    setContent(HANDLE, 'videos')
    if not is_folder:
        list_item.setProperty('IsPlayable', 'true')
    addDirectoryItem(HANDLE, dir_url, list_item, is_folder)
def getlink(url, ref, luu):
    r = urlquick.get(url, timeout=20, max_age=luu, headers={'user-agent': UA,'referer': ref.encode('utf-8')})
    r.encoding = 'utf-8'
    return r
def referer(url):
    parsed_url = urlparse(url.strip())
    return f'{parsed_url.scheme}://{parsed_url.netloc}/'
def process_items(items, item_type):
    for k in items:
        name = k['name']
        description = k.get('description', name)
        image = k['image']['url'] if k.get('image') else ICON
        if k.get('remote_data'):
            addDir(name, image, description, 'remote_data', url=k['remote_data']['url'], name=name, anh=image)
        elif k.get('sources'):
            for a in k['sources']:
                for b in a['contents']:
                    for c in b['streams']:
                        for d in c['stream_links']:
                            addDir(f'{name} [COLOR yellow]{d["name"]}[/COLOR]', image, description, 'play', link = d['url'], sub = [e['url'] for e in d.get('subtitles', [])], is_folder=False)
        if k.get('channels'):
            for a in k['channels']:
                tentran = a['name']
                anhtran = a['image']['url']
                if a.get('sources'):
                    for b in a['sources']:
                        for c in b['contents']:
                            for d in c['streams']:
                                blv = d['name']
                                for e in d['stream_links']:
                                    if e['type'] != 'webview':
                                        tenf = f'{tentran} [COLOR yellow]{blv}[/COLOR] [COLOR red]{e["name"]}[/COLOR]'
                                        if e.get('request_headers'):
                                            addDir(tenf, anhtran, tenf, 'play', link = e['url'], ref = e['request_headers'][0]['value'], is_folder=False)
                                        else:
                                            addDir(tenf, anhtran, tenf, 'play', link = e['url'], is_folder=False)
def router(paramstring):
    params = dict(parse_qsl(paramstring))
    if not params:
        dulieu = {
            'Xôi lạc TV':'https://sport.xoilaczz.link/providers',
            'Phim Mới':'https://iptv.phimmoizzz.org',
            'Nắng Cực':'https://iptv.nangcucz.link'
            }
        for h in dulieu:
            addDir(h, ICON, h, 'index_xemplay', url = dulieu[h])
        endOfDirectory(HANDLE)
    elif params['mode'] == 'index_xemplay':
        u = params['url']
        r = getlink(u, u, -1).json()
        if r.get('search'):
            addDir('Tìm phim', searchimg, 'Tìm phim', 'search', url = f"{r['search']['url']}?{r['search']['search_key']}=")
        for k in r['groups']:
            if k.get('remote_data'):
                tenkenh = k.get('channels_title', k['name'])
                addDir(tenkenh, ICON, tenkenh, 'list_xemplay', url = k['remote_data']['url'], p = 1)
        if r.get('channels_title'):
            tenindex = r['channels_title']
            addDir(tenindex, ICON, tenindex, 'list_xemplay', url = r['url'], p = 1)
        if r.get('sorts'):
            for k in r['sorts']:
                if k['type'] == 'radio':
                    tenkenh = f"[COLOR yellow]{k['text']}[/COLOR]"
                    addDir(tenkenh, ICON, tenkenh, 'list_xemplay', url = k['url'], p = 1)
                if k['type'] == 'dropdown':
                    name = k['text']
                    for m in k['value']:
                        tenkenh = f"[COLOR yellow]{name}[/COLOR] {m['text']}"
                        addDir(tenkenh, ICON, tenkenh, 'list_xemplay', url = m['url'], p = 1)
        endOfDirectory(HANDLE)
    elif params['mode'] == 'list_xemplay':
        params_url = params['url']
        uj = getlink(params_url, params_url, -1).json()
        u = uj['url']
        numpage = int(params['p'])
        page_key = params.get('page_key', uj.get('paging', {}).get('page_key'))
        size_key = params.get('size_key', uj.get('paging', {}).get('size_key'))
        allkey = f'{page_key}={numpage}&{size_key}=50'
        ux = f'{u}&{allkey}' if '?' in u else f'{u}?{allkey}'
        try:
            r = getlink(ux, ux, -1).json()
        except:
            ux = f'{params_url}&{allkey}' if '?' in params_url else f'{allkey}'
            r = getlink(ux, ux, -1).json()
        if r.get('channels'):
            process_items(r['channels'], 'channels')
        elif r.get('groups'):
            process_items(r['groups'], 'groups')
        last_page = r.get('pageInfo', {}).get('last_page', 0)
        if last_page > int(numpage):
            next_page = str(numpage + 1)
            tenpage = f'Trang {next_page}'
            addDir(tenpage, nextimg, tenpage, 'list_xemplay', url = u, page_key=r['paging']['page_key'], size_key=r['paging']['size_key'], p = next_page)
        endOfDirectory(HANDLE)
    elif params['mode'] == 'remote_data':
        u = params['url']
        img = params['anh']
        phim = params['name']
        r = getlink(u, u, -1).json()
        if r.get('sources'):
            for a in r['sources']:
                host = a['name']
                for b in a['contents']:
                    mua = b['name']
                    for c in b['streams']:
                        server = c['name']
                        for d in c['stream_links']:
                            if d['type'] != 'webview':
                                tenf = f"{phim} [COLOR yellow]{mua} Tập {server}[/COLOR] [COLOR red]{host}[/COLOR] {d['name']}"
                                addDir(tenf, img, tenf, 'play', link = d['url'], sub = [e['url'] for e in d.get('subtitles', [])], is_folder=False)
        if r.get('channels'):
            for k in r['channels']:
                name = k['name']
                image = k['image']['url']
                for a in k['sources']:
                    for b in a['contents']:
                        for c in b['streams']:
                            for d in c['stream_links']:
                                if d['type'] != 'webview':
                                    tenf = f"{name} [COLOR yellow]{d['name']}[/COLOR]"
                                    addDir(tenf, image, tenf, 'play', link = d['url'], sub = [e['url'] for e in d.get('subtitles', [])], is_folder=False)
        endOfDirectory(HANDLE)
    elif params['mode'] =='search':
        query = xbmcgui.Dialog().input(u'Tìm: tên phim ...', type=xbmcgui.INPUT_ALPHANUM)
        if query:
            search_query = quote_plus(query)
            u = f'{params["url"]}{search_query}'
            r = getlink(u, u, -1).json()
            for a in r['groups']:
                host = a['name']
                for b in a['channels']:
                    name = b['name']
                    description = b.get('description', name)
                    image = b['image']['url']
                    ten = f'[COLOR yellow]{host}[/COLOR] {name}'
                    if b.get('remote_data'):
                        addDir(ten, image, description, 'remote_data', url = b['remote_data']['url'], name = name, anh = image)
                    if b.get('sources'):
                        for c in b['sources']:
                            for d in c['contents']:
                                for e in d['streams']:
                                    for f in e['stream_links']:
                                        ten = f"{name} [COLOR yellow]{f['name']}[/COLOR]"
                                        addDir(ten, image, ten, 'play', link = f['url'], sub = [g['url'] for g in f.get('subtitles', [])], is_folder=False)
            if r.get('channels'):
                for c in r['channels']:
                    addDir(f'{host} {name}', c['image']['url'], c['description'], 'remote_data', url = c['remote_data']['url'], name = c['name'], anh = c['image']['url'])
        endOfDirectory(HANDLE)
    elif params['mode'] == 'play':
        play_item = xbmcgui.ListItem(offscreen=True)
        if params.get('sub'):
            play_item.setSubtitles(json.loads(params['sub']))
        hdr = f'verifypeer=false&User-Agent={unquote(UA)}'
        linkplay = re.sub(r'\s+', '%20', params['link'].strip(), flags=re.UNICODE)
        if params.get('ref'):
            hdr += f'&Referer={referer(params["ref"])}'
        play_item.setProperty('inputstream', 'inputstream.adaptive')
        play_item.setProperty('inputstream.adaptive.stream_headers', hdr)
        play_item.setProperty('inputstream.adaptive.manifest_headers', hdr)
        play_item.setPath(linkplay)
        setResolvedUrl(HANDLE, True, listitem=play_item)
if __name__ == '__main__':
    router(sys.argv[2][1:])